<?php

namespace App\Http\Controllers\Api\V2;

use Illuminate\Http\Request;

class PaymentController extends Controller
{
    public function cashOnDelivery(Request $request)
    {
        $order = new OrderController;
        return $order->store($request);
    }

    public function manualPayment(Request $request)
    {
        $order = new OrderController;
        return $order->store($request);
    }

    private $sslcz;

    public function __construct()
    {
        $config = [
            'store_id'       => config('sslcommerz.store_id'),
            'store_password' => config('sslcommerz.store_password'),
            'is_testmode'    => config('sslcommerz.test_mode'),
        ];
        $this->sslcz = new \Karim007\LaravelSslcommerzRecharge\Facade\SslCommerzPaymentFacade($config);
    }

    public function initiate(Request $request)
    {
        $request->validate([
            'amount'   => 'required|numeric|min:1',
            'name'     => 'required|string',
            'email'    => 'required|email',
            'phone'    => 'required|string',
            'address'  => 'required|string',
        ]);

        $transactionId = Str::uuid();

        // Save order to DB
        $order = Order::create([
            'transaction_id' => $transactionId,
            'amount'         => $request->amount,
            'status'         => 'pending',
            'customer_name'  => $request->name,
            'customer_email' => $request->email,
        ]);

        $postData = [
            'total_amount'      => $request->amount,
            'currency'          => 'BDT',
            'tran_id'           => $transactionId,
            'success_url'       => config('sslcommerz.success_url'),
            'fail_url'          => config('sslcommerz.fail_url'),
            'cancel_url'        => config('sslcommerz.cancel_url'),
            'ipn_url'           => config('sslcommerz.ipn_url'),
            'product_name'      => 'Order #' . $order->id,
            'product_category'  => 'general',
            'product_profile'   => 'general',
            'cus_name'          => $request->name,
            'cus_email'         => $request->email,
            'cus_phone'         => $request->phone,
            'cus_add1'          => $request->address,
            'cus_city'          => 'Dhaka',
            'cus_country'       => 'Bangladesh',
            'ship_name'         => $request->name,
            'ship_add1'         => $request->address,
            'ship_city'         => 'Dhaka',
            'ship_country'      => 'Bangladesh',
            'shipping_method'   => 'NO',
            'num_of_item'       => 1,
            'emi_option'        => 0,
        ];

        $response = $this->sslcz->makePayment($postData, 'checkout', 'json');

        if (!empty($response['GatewayPageURL'])) {
            return response()->json([
                'status'      => 'success',
                'gateway_url' => $response['GatewayPageURL'],
                'session_key' => $response['sessionkey'],
            ]);
        }

        return response()->json(['status' => 'error', 'message' => 'Payment initiation failed'], 500);
    }

    public function success(Request $request)
    {
        $tran_id = $request->tran_id;

        // Validate IPN
        $validation = $this->sslcz->orderValidate($tran_id, $request->amount, 'BDT', $request->all());

        if ($validation) {
            Order::where('transaction_id', $tran_id)->update(['status' => 'completed']);
            // Redirect to frontend success page
            return redirect(env('FRONTEND_URL') . '/payment/success?tran_id=' . $tran_id);
        }

        return redirect(env('FRONTEND_URL') . '/payment/fail');
    }

    public function fail(Request $request)
    {
        Order::where('transaction_id', $request->tran_id)->update(['status' => 'failed']);
        return redirect(env('FRONTEND_URL') . '/payment/fail');
    }

    public function cancel(Request $request)
    {
        Order::where('transaction_id', $request->tran_id)->update(['status' => 'cancelled']);
        return redirect(env('FRONTEND_URL') . '/payment/cancel');
    }

    public function ipn(Request $request)
    {
        if ($request->tran_id) {
            $validation = $this->sslcz->orderValidate(
                $request->tran_id, $request->amount, 'BDT', $request->all()
            );
            if ($validation) {
                Order::where('transaction_id', $request->tran_id)->update(['status' => 'completed']);
            }
        }
        return response()->json(['status' => 'IPN received']);
    }
}
