<?php

namespace App\Http\Controllers\Api\V2;

use App\Models\Address;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Cart;
use App\Models\Product;
use App\Models\OrderDetail;
use App\Models\Coupon;
use App\Models\CouponUsage;
use App\Models\BusinessSetting;
use App\Models\User;
use DB;
use \App\Utility\NotificationUtility;
use App\Models\CombinedOrder;
use App\Http\Controllers\AffiliateController;

class OrderController extends Controller
{

    private function sms_send($number, $message)
    {
        $url = "http://bulksmsbd.net/api/smsapi";

        $data = [
            "api_key" => "tto9lg9fbL5HV6yRz88A",
            "senderid" => "8809648905551",
            "number" => $number,
            "message" => $message
        ];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data); // Don't use http_build_query
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $response = curl_exec($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);

        if ($curl_error) {
            \Log::error('SMS Send CURL Error: ' . $curl_error);
            return false;
        }

        \Log::info('SMS API Response: ' . $response);

        // Check if response indicates success
        // Adjust this based on what the API returns for success
        return $response;
    }
    public function store(Request $request, $set_paid = false)

    {
        if(!auth()->user()->id){
            if (get_setting('minimum_order_amount_check') == 1) {
                $subtotal = 0;
                foreach (Cart::where('temp_user_id', $request->temp_user_id)->active()->get() as $key => $cartItem) {
                    $product = Product::find($cartItem['product_id']);
                    $subtotal += cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                }
                if ($subtotal < get_setting('minimum_order_amount')) {
                    return $this->failed(translate("You order amount is less then the minimum order amount"));
                }
            }

            $cartItems = Cart::where('temp_user_id', $request->temp_user_id)->active()->get();

        }else{
            if (get_setting('minimum_order_amount_check') == 1) {
                $subtotal = 0;
                foreach (Cart::where('user_id', auth()->user()->id)->active()->get() as $key => $cartItem) {
                    $product = Product::find($cartItem['product_id']);
                    $subtotal += cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                }
                if ($subtotal < get_setting('minimum_order_amount')) {
                    return $this->failed(translate("You order amount is less then the minimum order amount"));
                }
            }

            $cartItems = Cart::where('user_id', auth()->user()->id)->active()->get();
        }


        if ($cartItems->isEmpty()) {
            return response()->json([
                'combined_order_id' => 0,
                'result' => false,
                'message' => translate('Cart is Empty')
            ]);
        }

        $user = User::find(auth()->user()->id);

        $address = Address::where('id', $cartItems->first()->address_id)->first();
        $shippingAddress = [];
        if ($address != null) {
            $shippingAddress['name']        = $user->name;
            $shippingAddress['email']       = $user->email;
            $shippingAddress['address']     = $address->address;
            $shippingAddress['country']     = $address->country->name;
            $shippingAddress['state']       = $address->state->name;
            $shippingAddress['city']        = $address->city->name;
            $shippingAddress['postal_code'] = $address->postal_code;
            $shippingAddress['phone']       = $address->phone;
            if ($address->latitude || $address->longitude) {
                $shippingAddress['lat_lang'] = $address->latitude . ',' . $address->longitude;
            }
        }

        $combined_order = new CombinedOrder;
        $combined_order->user_id = $user->id;
        $combined_order->shipping_address = json_encode($shippingAddress);
        $combined_order->save();

        $seller_products = array();
        foreach ($cartItems as $cartItem) {
            $product_ids = array();
            $product = Product::find($cartItem['product_id']);
            if (isset($seller_products[$product->user_id])) {
                $product_ids = $seller_products[$product->user_id];
            }
            array_push($product_ids, $cartItem);
            $seller_products[$product->user_id] = $product_ids;
        }

        foreach ($seller_products as $seller_product) {
            $order = new Order;
            $order->combined_order_id = $combined_order->id;
            $order->user_id = $user->id;
            $order->shipping_address = $combined_order->shipping_address;

            $order->order_from = 'app';
            $order->payment_type = $request->payment_type;
            $order->delivery_viewed = '0';
            $order->payment_status_viewed = '0';
            $order->code = date('Ymd-His') . rand(10, 99);
            $order->date = strtotime('now');
            if ($set_paid) {
                $order->payment_status = 'paid';
            } else {
                $order->payment_status = 'unpaid';
            }

            $order->save();

            $subtotal = 0;
            $tax = 0;
            $shipping = 0;
            $coupon_discount = 0;

            //Order Details Storing
            foreach ($seller_product as $cartItem) {
                $product = Product::find($cartItem['product_id']);

                $subtotal += cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                $tax += cart_product_tax($cartItem, $product, false) * $cartItem['quantity'];
                $coupon_discount += $cartItem['discount'];

                $product_variation = $cartItem['variation'];

                $product_stock = $product->stocks->where('variant', $product_variation)->first();
                if ($product->digital != 1 && $cartItem['quantity'] > $product_stock->qty) {
                    $order->delete();
                    $combined_order->delete();
                    return response()->json([
                        'combined_order_id' => 0,
                        'result' => false,
                        'message' => translate('The requested quantity is not available for ') . $product->name
                    ]);
                } elseif ($product->digital != 1) {
                    $product_stock->qty -= $cartItem['quantity'];
                    $product_stock->save();
                }

                $order_detail = new OrderDetail;
                $order_detail->order_id = $order->id;
                $order_detail->seller_id = $product->user_id;
                $order_detail->product_id = $product->id;
                $order_detail->variation = $product_variation;
                $order_detail->price = cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                $order_detail->tax = cart_product_tax($cartItem, $product, false) * $cartItem['quantity'];
                $order_detail->shipping_type = $cartItem['shipping_type'];
                $order_detail->product_referral_code = $cartItem['product_referral_code'];
                $order_detail->shipping_cost = $cartItem['shipping_cost'];

                $shipping += $order_detail->shipping_cost;

                //End of storing shipping cost
                if (addon_is_activated('club_point')) {
                    $order_detail->earn_point = $product->earn_point;
                }

                $order_detail->quantity = $cartItem['quantity'];
                $order_detail->save();

                $product->num_of_sale = $product->num_of_sale + $cartItem['quantity'];
                $product->save();

                $order->seller_id = $product->user_id;

                $order->shipping_type = $cartItem['shipping_type'];
                if ($cartItem['shipping_type'] == 'pickup_point') {
                    $order->pickup_point_id = $cartItem['pickup_point'];
                }
                if ($cartItem['shipping_type'] == 'carrier') {
                    $order->carrier_id = $cartItem['carrier_id'];
                }

                if ($product->added_by == 'seller' && $product->user->seller != null) {
                    $seller = $product->user->seller;
                    $seller->num_of_sale += $cartItem['quantity'];
                    $seller->save();
                }

                if (addon_is_activated('affiliate_system')) {
                    if ($order_detail->product_referral_code) {
                        $referred_by_user = User::where('referral_code', $order_detail->product_referral_code)->first();

                        $affiliateController = new AffiliateController;
                        $affiliateController->processAffiliateStats($referred_by_user->id, 0, $order_detail->quantity, 0, 0);
                    }
                }
            }

            $order->grand_total = $subtotal + $tax + $shipping;

            if ($seller_product[0]->coupon_code != null) {
                $order->coupon_discount = $coupon_discount;
                $order->grand_total -= $coupon_discount;

                $coupon_usage = new CouponUsage;
                $coupon_usage->user_id = $user->id;
                $coupon_usage->coupon_id = Coupon::where('code', $seller_product[0]->coupon_code)->first()->id;
                $coupon_usage->save();
            }

            $combined_order->grand_total += $order->grand_total;

            if (strpos($request->payment_type, "manual_payment_") !== false) { // if payment type like  manual_payment_1 or  manual_payment_25 etc)

                $order->manual_payment = 1;
                $order->save();
            }

            $order->save();
        }
        $combined_order->save();
        if(!auth()->user()->id) {
            Cart::where('temp_user_id', $request->temp_user_id)->delete();
        }else{
            Cart::where('user_id', auth()->user()->id)->active()->delete();
        }

        if (
            $request->payment_type == 'cash_on_delivery'
            || $request->payment_type == 'wallet'
            || strpos($request->payment_type, "manual_payment_") !== false // if payment type like  manual_payment_1 or  manual_payment_25 etc
        ) {
            NotificationUtility::sendOrderPlacedNotification($order);
        }

        return response()->json([
            'combined_order_id' => $combined_order->id,
            'result' => true,
            'message' => translate('Your order has been placed successfully')
        ]);
    }

    public function GustOrderstore(Request $request, $set_paid = false)
    {


       if (!auth()->check()) {
            if (get_setting('minimum_order_amount_check') == 1) {
                $subtotal = 0;
                foreach (Cart::where('temp_user_id', $request->temp_user_id)->get() as $key => $cartItem) {
                    $product = Product::find($cartItem['product_id']);
                    $subtotal += cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                }
                if ($subtotal < get_setting('minimum_order_amount')) {
                    return $this->failed(translate("You order amount is less then the minimum order amount"));
                }
            }

            $cartItems = Cart::where('temp_user_id', $request->temp_user_id)->get();
        }else{
            if (get_setting('minimum_order_amount_check') == 1) {
                $subtotal = 0;
                foreach (Cart::where('user_id', $request->user_id)->get() as $key => $cartItem) {
                    $product = Product::find($cartItem['product_id']);
                    $subtotal += cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                }
                if ($subtotal < get_setting('minimum_order_amount')) {
                    return $this->failed(translate("You order amount is less then the minimum order amount"));
                }
            }

            $cartItems = Cart::where('user_id', $request->user_id)->get();
        }


        if ($cartItems->isEmpty()) {
            return response()->json([
                'combined_order_id' => 0,
                'result' => false,
                'message' => translate('Cart is Empty')
            ]);
        }

     $user = User::where('verification_code',$request->verification_code)->first();
        if($request->verification_code  != $user->verification_code){{
            return response()->json([

                'result' => false,
                'message' => translate('Verifcation code not matched')
            ]);
        }}


            $shippingAddress['name']        = $request->name ?? '';
            $shippingAddress['email']       = $request->email ?? '';
            $shippingAddress['address']     = $request->address ?? '';
            $shippingAddress['country']     = $request->country->name ?? '';
            $shippingAddress['state']       = $request->state->name ?? '';
            $shippingAddress['city']        = $request->city->name ?? '';
            $shippingAddress['postal_code'] = $request->postal_code ?? '';
            $shippingAddress['phone']       = $request->phone ?? '';


        $combined_order = new CombinedOrder;
        $combined_order->user_id = $user->id;
        $combined_order->shipping_address = json_encode($shippingAddress);
        $combined_order->save();

        $seller_products = array();
        foreach ($cartItems as $cartItem) {
            $product_ids = array();
            $product = Product::find($cartItem['product_id']);
            if (isset($seller_products[$product->user_id])) {
                $product_ids = $seller_products[$product->user_id];
            }
            array_push($product_ids, $cartItem);
            $seller_products[$product->user_id] = $product_ids;
        }

        foreach ($seller_products as $seller_product) {
            $order = new Order;
            $order->combined_order_id = $combined_order->id;
            $order->user_id = $user->id;
            $order->shipping_address = $combined_order->shipping_address;
            $order->shipping_cost = $request->shipping_cost;
            $order->order_from = 'app';
            // $order->payment_type = $request->payment_type;
           $order->payment_type = "Cash on delivery";
            $order->delivery_viewed = '0';
            $order->payment_status_viewed = '0';
            $order->code = date('Ymd-His') . rand(10, 99);
            $order->date = strtotime('now');
            if ($set_paid) {
                $order->payment_status = 'paid';
            } else {
                $order->payment_status = 'unpaid';
            }

            $order->save();

            $subtotal = 0;
            $tax = 0;
            $shipping = 0;
            $coupon_discount = 0;

            //Order Details Storing
            foreach ($seller_product as $cartItem) {
                $product = Product::find($cartItem['product_id']);

                $subtotal += cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                $tax += cart_product_tax($cartItem, $product, false) * $cartItem['quantity'];
                $coupon_discount += $cartItem['discount'];

                $product_variation = $cartItem['variation'];

//                $product_stock = $product->stocks->where('variant', $product_variation)->first();
                if ($product->digital != 1 && $cartItem['quantity'] > $product->current_stock) {
                    $order->delete();
                    $combined_order->delete();
                    return response()->json([
                        'combined_order_id' => 0,
                        'result' => false,
                        'message' => translate('The requested quantity is not available for ') . $product->name
                    ]);
                } elseif ($product->digital != 1) {
                    $product->current_stock -= $cartItem['quantity'];
                    $product->save();
                }

                $order_detail = new OrderDetail;
                $order_detail->order_id = $order->id;
                $order_detail->seller_id = $product->user_id;
                $order_detail->product_id = $product->id;
                $order_detail->variation = $product_variation;
                $order_detail->price = cart_product_price($cartItem, $product, false, false) * $cartItem['quantity'];
                $order_detail->tax = cart_product_tax($cartItem, $product, false) * $cartItem['quantity'];
                $order_detail->shipping_type = $cartItem['shipping_type'];
                $order_detail->product_referral_code = $cartItem['product_referral_code'];
                $order_detail->shipping_cost = $cartItem['shipping_cost'];

                $shipping += $order_detail->shipping_cost;

                //End of storing shipping cost
                if (addon_is_activated('club_point')) {
                    $order_detail->earn_point = $product->earn_point;
                }

                $order_detail->quantity = $cartItem['quantity'];
                $order_detail->save();

                $product->num_of_sale = $product->num_of_sale + $cartItem['quantity'];
                $product->save();

                $order->seller_id = $product->user_id;

                $order->shipping_type = $cartItem['shipping_type'];
                if ($cartItem['shipping_type'] == 'pickup_point') {
                    $order->pickup_point_id = $cartItem['pickup_point'];
                }
                if ($cartItem['shipping_type'] == 'carrier') {
                    $order->carrier_id = $cartItem['carrier_id'];
                }

                if ($product->added_by == 'seller' && $product->user->seller != null) {
                    $seller = $product->user->seller;
                    $seller->num_of_sale += $cartItem['quantity'];
                    $seller->save();
                }

                if (addon_is_activated('affiliate_system')) {
                    if ($order_detail->product_referral_code) {
                        $referred_by_user = User::where('referral_code', $order_detail->product_referral_code)->first();

                        $affiliateController = new AffiliateController;
                        $affiliateController->processAffiliateStats($referred_by_user->id, 0, $order_detail->quantity, 0, 0);
                    }
                }
            }

             $shipping_cost = $request->shipping_cost ?? 0;
            $discount = $request->discount ?? 0;

            $order->grand_total = $subtotal + $shipping_cost - $discount;

            // $order->grand_total = $subtotal + $tax + $shipping;

            if ($seller_product[0]->coupon_code != null) {
                $order->coupon_discount = $coupon_discount;
                $order->grand_total -= $coupon_discount;

                $coupon_usage = new CouponUsage;
                $coupon_usage->user_id = $user->id;
                $coupon_usage->coupon_id = Coupon::where('code', $seller_product[0]->coupon_code)->first()->id;
                $coupon_usage->save();
            }

            $combined_order->grand_total += $order->grand_total;

            if (strpos($request->payment_type, "manual_payment_") !== false) { // if payment type like  manual_payment_1 or  manual_payment_25 etc)

                $order->manual_payment = 1;
                $order->save();
            }

            $order->save();
        }
        $combined_order->save();
        if (!auth()->check()) {

            Cart::where('temp_user_id', $request->temp_user_id)->delete();
        }else{
           Cart::where('user_id', auth()->user()->id)->delete();
        }


        $phone = '01844545500';
        if (!str_starts_with($phone, '880')) {
            if (str_starts_with($phone, '0')) {
                $phone = '880' . substr($phone, 1);
            } elseif (str_starts_with($phone, '+880')) {
                $phone = substr($phone, 1);
            } else {
                $phone = '880' . $phone;
            }
        }

        // Send SMS
        $message = "New Order Received!\n";
        $message .= "Order ID: " . $order->code . "\n";
        $message .= "Customer Name: " . ($request->name ?? 'Customer') . "\n";
        $message .= "Total Amount: " . number_format($combined_order->grand_total, 0) . "\n";
        $message .= "Thank you,\n";
        $message .= "Zhen Aura";

// Send SMS
        $response = $this->sms_send($phone, $message);


        // Customer phone normalize
        $customerPhone = $request->phone;

        if (!str_starts_with($customerPhone, '880')) {
            if (str_starts_with($customerPhone, '0')) {
                $customerPhone = '880' . substr($customerPhone, 1);
            } elseif (str_starts_with($customerPhone, '+880')) {
                $customerPhone = substr($customerPhone, 1);
            } else {
                $customerPhone = '880' . $customerPhone;
            }
        }


        $customerMessage  = "Dear " . ($request->name ?? 'Customer') . ",\n";
        $customerMessage .= "Your order has been placed successfully!\n";
        $customerMessage .= "Order ID: " . $order->code . "\n";
        $customerMessage .= "Total Amount: " . number_format($combined_order->grand_total, 0) . "\n";
        $customerMessage .= "Payment Status: " . strtoupper($order->payment_status) . "\n";
        $customerMessage .= "Thank you for shopping with us.\n";
        $customerMessage .= "Zhen Aura";

        $customerSmsResponse = $this->sms_send($customerPhone, $customerMessage);



        if (
            $request->payment_type == 'cash_on_delivery'
            || $request->payment_type == 'wallet'
            || strpos($request->payment_type, "manual_payment_") !== false // if payment type like  manual_payment_1 or  manual_payment_25 etc
        ) {
            NotificationUtility::sendOrderPlacedNotification($order);
        }

        return response()->json([
            'combined_order_id' => $combined_order->id,
            'order_id' => $order->id,
            'result' => true,
            'message' => translate('Your order has been placed successfully')
        ]);

    }

     public function wholeSaleOrderstore(Request $request, $set_paid = false)
    {
//dd($request->all());
        $shippingAddress['name']        = $request->name ?? '';
        $shippingAddress['email']       = $request->email ?? '';
        $shippingAddress['address']     = $request->address ?? '';
        $shippingAddress['country']     = $request->country->name ?? '';
        $shippingAddress['state']       = $request->state->name ?? '';
        $shippingAddress['city']        = $request->city->name ?? '';
        $shippingAddress['postal_code'] = $request->postal_code ?? '';
        $shippingAddress['phone']       = $request->phone ?? '';


         $order = new Order;


            $order->shipping_address = json_encode($shippingAddress);
            $order->order_type ='wholesale';

            $order->order_from = 'app';

            $order->delivery_viewed = '0';
            $order->payment_status_viewed = '0';
            $order->code = date('Ymd-His') . rand(10, 99);
            $order->date = strtotime('now');
            if ($set_paid) {
                $order->payment_status = 'paid';
            } else {
                $order->payment_status = 'unpaid';
            }

            $order->save();


        foreach ($request->product_id as $index => $productId) {

            $product = Product::find($productId);

            if (!$product) {
                continue;
            }

            $qty = $request->quantity[$index] ?? 1;

            $order_detail = new OrderDetail;
            $order_detail->order_id = $order->id;
            $order_detail->seller_id = $product->user_id;
            $order_detail->product_id = $product->id;
            $order_detail->price = $product->unit_price * $qty;
            $order_detail->quantity = $qty;
            $order_detail->save();

            $product->num_of_sale += $qty;
            $product->save();


        }


        $phone = '01844545500';
        if (!str_starts_with($phone, '880')) {
            if (str_starts_with($phone, '0')) {
                $phone = '880' . substr($phone, 1);
            } elseif (str_starts_with($phone, '+880')) {
                $phone = substr($phone, 1);
            } else {
                $phone = '880' . $phone;
            }
        }


        $message = "New Order Received!\n";
        $message .= "Order ID: " . $order->code . "\n";
        $message .= "Customer Name: " . ($request->name ?? 'Customer') . "\n";

        $message .= "Thank you,\n";
        $message .= "Zhen Aura";


        $response = $this->sms_send($phone, $message);


        // Customer phone normalize
        $customerPhone = $request->phone;

        if (!str_starts_with($customerPhone, '880')) {
            if (str_starts_with($customerPhone, '0')) {
                $customerPhone = '880' . substr($customerPhone, 1);
            } elseif (str_starts_with($customerPhone, '+880')) {
                $customerPhone = substr($customerPhone, 1);
            } else {
                $customerPhone = '880' . $customerPhone;
            }
        }


        $customerMessage  = "Dear " . ($request->name ?? 'Customer') . ",\n";
        $customerMessage .= "Your order has been placed successfully!\n";
        $customerMessage .= "Order ID: " . $order->code . "\n";
        $customerMessage .= "Thank you for shopping with us.\n";
        $customerMessage .= "Zhen Aura";

        $customerSmsResponse = $this->sms_send($customerPhone, $customerMessage);



        return response()->json([

            'order_id' => $order->id,
            'result' => true,
            'message' => translate('Your order has been placed successfully')
        ]);

    }
    public function userOrder($id)
    {
        $order = Order::with('orderDetails.product')->findOrFail($id);
        return response()->json([
            'success' => true,
            'order' => $order,
        ]);
    }

    public function order_list()
    {
        $order = Order::with('orderDetails.product')->where('user_id', auth()->user()->id)->get();
        return response()->json([
            'success' => true,
            'order' => $order,
        ]);
    }

    public function order_cancel($id)
    {
        $order = Order::where('id', $id)->where('user_id', auth()->user()->id)->first();
        if ($order && ($order->delivery_status == 'pending' && $order->payment_status == 'unpaid')) {
            $order->delivery_status = 'cancelled';
            $order->save();

            foreach ($order->orderDetails as $key => $orderDetail) {
                $orderDetail->delivery_status = 'cancelled';
                $orderDetail->save();
                product_restock($orderDetail);
            }

            return $this->success(translate('Order has been canceled successfully'));
        } else {
            return  $this->failed(translate('Something went wrong'));
        }
    }

    public function trackOrder(Request $request)
    {
        if ($request->has('order_code')) {
            $order = Order::with('orderStatus')->where('code', $request->order_code)->first();
            if ($order != null) {
                return response()->json([
                    'success' => true,
                    'order' => $order,
                ]);
            }
        }

    }
}
